<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-Frame-Options" content="SAMEORIGIN">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    <meta http-equiv="Referrer-Policy" content="strict-origin-when-cross-origin">
    <title>ورود به حساب کاربری - مکان‌های ایران</title>
    <meta name="description" content="ورود به حساب کاربری سیستم مکان‌های ایران - کشف، امتیازدهی و اشتراک‌گذاری مکان‌های جذاب">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/fonts.css')); ?>">

    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --warning-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
            --glass-bg: rgba(255, 255, 255, 0.25);
            --glass-border: rgba(255, 255, 255, 0.18);
            --shadow-light: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
            --shadow-heavy: 0 15px 35px rgba(0, 0, 0, 0.1);
            --border-radius: 16px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IRANSans', 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }

        /* Animated Background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><defs><radialGradient id="a" cx="50%" cy="50%"><stop offset="0%" stop-color="%23ffffff" stop-opacity="0.1"/><stop offset="100%" stop-color="%23ffffff" stop-opacity="0"/></radialGradient></defs><circle cx="200" cy="300" r="150" fill="url(%23a)"/><circle cx="800" cy="200" r="120" fill="url(%23a)"/><circle cx="300" cy="700" r="100" fill="url(%23a)"/><circle cx="700" cy="600" r="80" fill="url(%23a)"/></svg>') no-repeat center center;
            background-size: cover;
            animation: float 30s ease-in-out infinite;
            pointer-events: none;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }

        .main-container {
            display: grid;
            grid-template-columns: 1fr 450px;
            gap: 3rem;
            width: 100%;
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
            align-items: center;
            min-height: 100vh;
        }

        /* Platform Stats Dashboard */
        .platform-stats {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2.5rem;
            box-shadow: var(--shadow-light);
            animation: slideInLeft 0.8s ease-out;
            height: fit-content;
        }

        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .stats-header {
            text-align: center;
            margin-bottom: 2.5rem;
            color: white;
        }

        .stats-header h2 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.75rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .stats-header p {
            opacity: 0.9;
            font-size: 1.1rem;
            line-height: 1.6;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            cursor: pointer;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .stat-card:hover::before {
            left: 100%;
        }

        .stat-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }

        .stat-icon {
            font-size: 2rem;
            margin-bottom: 1rem;
            color: white;
            display: block;
        }

        .stat-value {
            font-size: 1.8rem;
            font-weight: 700;
            color: white;
            margin-bottom: 0.5rem;
            display: block;
        }

        .stat-label {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.8);
            line-height: 1.4;
        }

        /* Growth Indicator */
        .growth-indicator {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            text-align: center;
        }

        .growth-value {
            font-size: 2.5rem;
            font-weight: 700;
            color: #4ade80;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .growth-label {
            color: rgba(255, 255, 255, 0.9);
            font-size: 1rem;
        }

        /* Popular Locations */
        .popular-locations {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }

        .popular-locations h4 {
            color: white;
            font-size: 1.2rem;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .location-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.75rem;
            margin-bottom: 0.5rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            transition: var(--transition);
        }

        .location-item:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateX(5px);
        }

        .location-name {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
        }

        .location-views {
            color: #4ade80;
            font-size: 0.8rem;
            font-weight: 600;
        }

        /* Recent Activities */
        .recent-activities {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            padding: 1.5rem;
        }

        .recent-activities h4 {
            color: white;
            font-size: 1.2rem;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .activity-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            margin-bottom: 0.5rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            transition: var(--transition);
        }

        .activity-item:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .activity-icon {
            color: #fbbf24;
            font-size: 0.9rem;
        }

        .activity-text {
            flex: 1;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.85rem;
        }

        .activity-time {
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.75rem;
        }

        /* Login Form Container */
        .login-form-container {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2.5rem;
            box-shadow: var(--shadow-light);
            animation: slideInRight 0.8s ease-out;
            height: fit-content;
        }

        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        .form-header {
            text-align: center;
            margin-bottom: 2rem;
            color: white;
        }

        .form-header h2 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .form-header p {
            opacity: 0.9;
            font-size: 1rem;
            line-height: 1.5;
        }

        /* Modern Form Styles */
        .modern-form {
            margin-bottom: 1.5rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: white;
            font-weight: 600;
            margin-bottom: 0.75rem;
            font-size: 0.95rem;
        }

        .required {
            color: #ef4444;
        }

        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 12px;
            padding: 1rem 3rem 1rem 1.25rem;
            font-size: 1rem;
            color: #333;
            transition: var(--transition);
            width: 100%;
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.95);
            border-color: rgba(102, 126, 234, 0.5);
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
            transform: scale(1.02);
        }

        .form-control::placeholder {
            color: rgba(0, 0, 0, 0.5);
        }

        .form-control.is-invalid {
            border-color: #ef4444;
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
        }

        .password-toggle {
            position: absolute;
            left: 1rem;
            background: none;
            border: none;
            color: #6b7280;
            cursor: pointer;
            padding: 0.5rem;
            border-radius: 6px;
            transition: var(--transition);
        }

        .password-toggle:hover {
            color: #374151;
            background: rgba(0, 0, 0, 0.05);
            transform: scale(1.1);
        }

        /* Remember Me Checkbox */
        .remember-wrapper {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-bottom: 1.5rem;
        }

        .custom-checkbox {
            position: relative;
            width: 20px;
            height: 20px;
        }

        .custom-checkbox input {
            opacity: 0;
            position: absolute;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

        .checkbox-mark {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.2);
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 4px;
            transition: var(--transition);
        }

        .custom-checkbox input:checked + .checkbox-mark {
            background: var(--primary-gradient);
            border-color: rgba(102, 126, 234, 0.8);
        }

        .checkbox-mark::after {
            content: '';
            position: absolute;
            display: none;
            left: 6px;
            top: 2px;
            width: 6px;
            height: 10px;
            border: solid white;
            border-width: 0 2px 2px 0;
            transform: rotate(45deg);
        }

        .custom-checkbox input:checked + .checkbox-mark::after {
            display: block;
        }

        .remember-label {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
            cursor: pointer;
            user-select: none;
        }

        /* Error Messages */
        .error-message {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: #ef4444;
            font-size: 0.85rem;
            margin-top: 0.5rem;
            background: rgba(239, 68, 68, 0.1);
            padding: 0.5rem 0.75rem;
            border-radius: 6px;
            border: 1px solid rgba(239, 68, 68, 0.2);
        }

        /* Alert Styles */
        .alert {
            border-radius: 12px;
            border: none;
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
            display: flex;
            align-items: center;
            gap: 0.75rem;
            animation: slideInDown 0.5s ease-out;
        }

        @keyframes slideInDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .alert-success {
            background: rgba(76, 175, 80, 0.2);
            color: #e8f5e8;
            border: 1px solid rgba(76, 175, 80, 0.3);
        }

        .alert-danger {
            background: rgba(244, 67, 54, 0.2);
            color: #ffebee;
            border: 1px solid rgba(244, 67, 54, 0.3);
        }

        /* Form Actions */
        .form-actions {
            margin-bottom: 1.5rem;
        }

        .btn {
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            font-size: 1rem;
            border: none;
            cursor: pointer;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            text-decoration: none;
            width: 100%;
        }

        .btn-primary {
            background: var(--primary-gradient);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
            color: white;
        }

        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.6s;
        }

        .btn-primary:hover::before {
            left: 100%;
        }

        .btn-loading {
            display: none;
        }

        .btn.loading .btn-text {
            display: none;
        }

        .btn.loading .btn-loading {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        /* Forgot Password Link */
        .forgot-password-link {
            text-align: center;
            margin-bottom: 1.5rem;
            padding: 1rem;
        }

        .forgot-password-link a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            font-size: 0.9rem;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .forgot-password-link a:hover {
            color: #fbbf24;
            background: rgba(251, 191, 36, 0.1);
            border-color: rgba(251, 191, 36, 0.2);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(251, 191, 36, 0.2);
        }

        .forgot-password-link i {
            font-size: 0.8rem;
        }

        /* Register Link */
        .register-link {
            text-align: center;
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.95rem;
        }

        .register-link a {
            color: #4ade80;
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
        }

        .register-link a:hover {
            color: #22c55e;
            text-shadow: 0 0 8px rgba(74, 222, 128, 0.5);
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .main-container {
                grid-template-columns: 1fr;
                gap: 2rem;
            }

            .platform-stats {
                order: 2;
            }

            .login-form-container {
                order: 1;
                max-width: 500px;
                margin: 0 auto;
            }
        }

        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }

            .platform-stats,
            .login-form-container {
                padding: 1.5rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }

            .stats-header h2 {
                font-size: 1.5rem;
            }

            .form-header h2 {
                font-size: 1.5rem;
            }
        }

        @media (max-width: 480px) {
            .main-container {
                padding: 0.5rem;
            }

            .platform-stats,
            .login-form-container {
                padding: 1rem;
            }

            .btn {
                padding: 0.875rem 1.5rem;
                font-size: 0.9rem;
            }
        }

        /* Enhanced Accessibility */
        @media (prefers-reduced-motion: reduce) {
            * {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }

        /* Enhanced Focus Management */
        .focus-visible {
            outline: 3px solid #667eea;
            outline-offset: 2px;
            border-radius: 4px;
        }

        /* Developer Credit Styles */
        .developer-credit {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 12px;
            padding: 0.75rem 1rem;
            color: white;
            font-size: 0.85rem;
            font-weight: 500;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transition: var(--transition);
            cursor: pointer;
            z-index: 1000;
        }

        .developer-credit:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.2);
        }

        .developer-credit .dev-icon {
            color: #4facfe;
            margin-left: 0.5rem;
            font-size: 1rem;
        }

        .developer-credit .dev-name {
            font-weight: 600;
            color: #ffffff;
        }

        .developer-credit .dev-role {
            font-size: 0.75rem;
            opacity: 0.8;
            margin-top: 0.25rem;
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Platform Stats Dashboard -->
        <div class="platform-stats">
            <div class="stats-header">
                <h2><i class="fas fa-chart-line"></i> آمار پلتفرم</h2>
                <p>به جامعه بزرگ کاشفان مکان‌های ایران بپیوندید</p>
            </div>

            <!-- Stats Grid -->
            <div class="stats-grid">
                <div class="stat-card" data-stat="users">
                    <i class="fas fa-users stat-icon"></i>
                    <span class="stat-value"><?php echo e(number_format($stats['total_users'] ?? 0)); ?></span>
                    <span class="stat-label">کاربران عضو</span>
                </div>

                <div class="stat-card" data-stat="locations">
                    <i class="fas fa-map-marker-alt stat-icon"></i>
                    <span class="stat-value"><?php echo e(number_format($stats['total_locations'] ?? 0)); ?></span>
                    <span class="stat-label">مکان ثبت شده</span>
                </div>

                <div class="stat-card" data-stat="ratings">
                    <i class="fas fa-star stat-icon"></i>
                    <span class="stat-value"><?php echo e(number_format($stats['total_ratings'] ?? 0)); ?></span>
                    <span class="stat-label">نظر و امتیاز</span>
                </div>

                <div class="stat-card" data-stat="online">
                    <i class="fas fa-circle stat-icon" style="color: #4ade80;"></i>
                    <span class="stat-value"><?php echo e($stats['online_users'] ?? 0); ?></span>
                    <span class="stat-label">کاربر آنلاین</span>
                </div>
            </div>

            <!-- Growth Indicator -->
            <div class="growth-indicator">
                <div class="growth-value">+<?php echo e($stats['platform_growth'] ?? 0); ?>%</div>
                <div class="growth-label">رشد ماهانه پلتفرم</div>
            </div>

            <!-- Popular Locations -->
            <?php if(!empty($stats['popular_locations'])): ?>
            <div class="popular-locations">
                <h4>
                    <i class="fas fa-fire"></i>
                    محبوب‌ترین مکان‌ها
                </h4>
                <?php $__currentLoopData = array_slice($stats['popular_locations'], 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="location-item">
                    <span class="location-name"><?php echo e($location['title'] ?? 'مکان نامشخص'); ?></span>
                    <span class="location-views"><?php echo e(number_format($location['view_count'] ?? 0)); ?> بازدید</span>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endif; ?>

            <!-- Recent Activities -->
            <?php if(!empty($stats['recent_activities'])): ?>
            <div class="recent-activities">
                <h4>
                    <i class="fas fa-clock"></i>
                    فعالیت‌های اخیر
                </h4>
                <?php $__currentLoopData = array_slice($stats['recent_activities'], 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="activity-item">
                    <i class="fas fa-<?php echo e($activity['type'] === 'registration' ? 'user-plus' : 'comment'); ?> activity-icon"></i>
                    <span class="activity-text"><?php echo e($activity['message']); ?></span>
                    <span class="activity-time"><?php echo e($activity['time']); ?></span>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endif; ?>
        </div>

        <!-- Login Form -->
        <div class="login-form-container">
            <div class="form-header">
                <h2><i class="fas fa-sign-in-alt"></i> ورود به حساب کاربری</h2>
                <p>به حساب کاربری خود وارد شوید و به کاوش ادامه دهید</p>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($error); ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('user.login')); ?>" method="POST" id="login-form" class="modern-form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" id="csrf-token-input">

                <!-- Email Field -->
                <div class="form-group">
                    <label for="email" class="form-label">
                        <i class="fas fa-envelope"></i>
                        ایمیل
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="email"
                               name="email"
                               id="email"
                               class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               value="<?php echo e(old('email')); ?>"
                               required
                               autocomplete="email"
                               placeholder="ایمیل خود را وارد کنید">
                    </div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Password Field -->
                <div class="form-group">
                    <label for="password" class="form-label">
                        <i class="fas fa-lock"></i>
                        رمز عبور
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="password"
                               name="password"
                               id="password"
                               class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               required
                               autocomplete="current-password"
                               placeholder="رمز عبور خود را وارد کنید">
                        <button type="button" class="password-toggle" data-target="password">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Remember Me -->
                <div class="remember-wrapper">
                    <div class="custom-checkbox">
                        <input type="checkbox" id="remember" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                        <span class="checkbox-mark"></span>
                    </div>
                    <label for="remember" class="remember-label">مرا به خاطر بسپار</label>
                </div>

                <!-- Submit Button -->
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary" id="login-btn">
                        <span class="btn-text">
                            <i class="fas fa-sign-in-alt"></i>
                            ورود به حساب کاربری
                        </span>
                        <div class="btn-loading">
                            <i class="fas fa-spinner fa-spin"></i>
                            در حال ورود...
                        </div>
                    </button>
                </div>
            </form>

            <!-- Forgot Password Link -->
            <div class="forgot-password-link">
                <a href="<?php echo e(route('user.password.request')); ?>">
                    <i class="fas fa-key"></i>
                    رمز عبور خود را فراموش کرده‌اید؟
                </a>
            </div>

            <!-- Register Link -->
            <div class="register-link">
                حساب کاربری ندارید؟
                <a href="<?php echo e(route('user.register')); ?>">همین حالا ثبت نام کنید</a>
            </div>
        </div>
    </div>

    <!-- Developer Credit -->
    <div class="developer-credit" onclick="showDeveloperInfo()">
        <div class="d-flex align-items-center">
            <i class="fas fa-laptop-code dev-icon"></i>
            <div>
                <div class="dev-name">یوسف رجستری</div>
                <div class="dev-role">Full-Stack Developer</div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        class ModernUserLogin {
            constructor() {
                this.init();
                this.setupEventListeners();
                this.animatePageLoad();
                this.startStatsAnimation();
            }

            init() {
                this.form = document.getElementById('login-form');
                this.submitBtn = document.getElementById('login-btn');
                this.emailInput = document.getElementById('email');
                this.passwordInput = document.getElementById('password');
                this.rememberCheckbox = document.getElementById('remember');

                this.isFormValid = false;
            }

            setupEventListeners() {
                // Password toggle functionality
                document.querySelectorAll('.password-toggle').forEach(toggle => {
                    toggle.addEventListener('click', (e) => this.togglePassword(e));
                });

                // Form validation
                if (this.emailInput) {
                    this.emailInput.addEventListener('input', () => this.validateForm());
                    this.emailInput.addEventListener('blur', () => this.validateEmail());
                }

                if (this.passwordInput) {
                    this.passwordInput.addEventListener('input', () => this.validateForm());
                }

                // Form submission
                if (this.form) {
                    this.form.addEventListener('submit', (e) => this.handleSubmit(e));
                }

                // Enhanced input interactions
                document.querySelectorAll('.form-control').forEach(input => {
                    input.addEventListener('focus', (e) => this.handleInputFocus(e));
                    input.addEventListener('blur', (e) => this.handleInputBlur(e));
                    input.addEventListener('keydown', (e) => this.handleKeyDown(e));
                });

                // Stats card interactions
                document.querySelectorAll('.stat-card').forEach(card => {
                    card.addEventListener('click', (e) => this.handleStatClick(e));
                });

                // Custom checkbox interaction
                if (this.rememberCheckbox) {
                    this.rememberCheckbox.addEventListener('change', (e) => this.handleRememberChange(e));
                }
            }

            togglePassword(e) {
                const button = e.currentTarget;
                const targetId = button.getAttribute('data-target');
                const input = document.getElementById(targetId);
                const icon = button.querySelector('i');

                if (input.type === 'password') {
                    input.type = 'text';
                    icon.className = 'fas fa-eye-slash';
                    button.setAttribute('aria-label', 'مخفی کردن رمز عبور');
                } else {
                    input.type = 'password';
                    icon.className = 'fas fa-eye';
                    button.setAttribute('aria-label', 'نمایش رمز عبور');
                }

                // Enhanced animation
                button.style.transform = 'scale(0.9) rotate(180deg)';
                setTimeout(() => {
                    button.style.transform = 'scale(1) rotate(0deg)';
                }, 200);
            }

            validateEmail() {
                const email = this.emailInput.value;
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

                if (email && !emailRegex.test(email)) {
                    this.showFieldError(this.emailInput, 'فرمت ایمیل صحیح نیست');
                    return false;
                } else {
                    this.clearFieldError(this.emailInput);
                    return true;
                }
            }

            validateForm() {
                const email = this.emailInput.value;
                const password = this.passwordInput.value;

                const isValid = email.length > 0 &&
                               password.length > 0 &&
                               this.validateEmail();

                this.isFormValid = isValid;
                this.submitBtn.disabled = !isValid;

                if (isValid) {
                    this.submitBtn.classList.add('valid');
                } else {
                    this.submitBtn.classList.remove('valid');
                }
            }

            handleInputFocus(e) {
                const wrapper = e.target.closest('.input-wrapper');
                if (wrapper) {
                    wrapper.style.transform = 'scale(1.02)';
                    wrapper.style.transition = 'transform 0.2s ease';
                    wrapper.classList.add('focused');
                }

                // Add focus ring
                e.target.style.boxShadow = '0 0 0 3px rgba(102, 126, 234, 0.2)';
            }

            handleInputBlur(e) {
                const wrapper = e.target.closest('.input-wrapper');
                if (wrapper) {
                    wrapper.style.transform = 'scale(1)';
                    wrapper.classList.remove('focused');
                }

                e.target.style.boxShadow = '';
            }

            handleKeyDown(e) {
                // Enhanced keyboard navigation
                if (e.key === 'Enter') {
                    const inputs = Array.from(document.querySelectorAll('.form-control'));
                    const currentIndex = inputs.indexOf(e.target);
                    const nextInput = inputs[currentIndex + 1];

                    if (nextInput) {
                        e.preventDefault();
                        nextInput.focus();
                    } else if (this.isFormValid) {
                        e.preventDefault();
                        this.submitBtn.click();
                    }
                }
            }

            handleSubmit(e) {
                if (!this.isFormValid) {
                    e.preventDefault();
                    this.showError('لطفاً تمام فیلدها را به درستی پر کنید');
                    return;
                }

                // Ensure CSRF token is present
                const csrfToken = document.querySelector('meta[name="csrf-token"]');
                const csrfInput = document.getElementById('csrf-token-input');

                if (csrfToken && csrfInput) {
                    csrfInput.value = csrfToken.getAttribute('content');
                }

                // Add loading state
                this.submitBtn.classList.add('loading');
                this.submitBtn.disabled = true;

                // Add success animation
                this.addSubmitAnimation();
            }

            handleStatClick(e) {
                const statCard = e.currentTarget;
                const statType = statCard.getAttribute('data-stat');

                // Add click animation
                statCard.style.transform = 'scale(0.95)';
                setTimeout(() => {
                    statCard.style.transform = 'scale(1)';
                }, 150);

                // Show info about the stat
                this.showStatInfo(statType, statCard);
            }

            handleRememberChange(e) {
                const checkbox = e.target;
                const checkboxMark = checkbox.nextElementSibling;

                if (checkbox.checked) {
                    checkboxMark.style.animation = 'checkboxCheck 0.3s ease-out';
                } else {
                    checkboxMark.style.animation = 'checkboxUncheck 0.3s ease-out';
                }

                setTimeout(() => {
                    checkboxMark.style.animation = '';
                }, 300);
            }

            showFieldError(input, message) {
                this.clearFieldError(input);

                const errorDiv = document.createElement('div');
                errorDiv.className = 'error-message';
                errorDiv.innerHTML = `<i class="fas fa-exclamation-triangle"></i> ${message}`;

                input.parentElement.parentElement.appendChild(errorDiv);
                input.classList.add('is-invalid');
            }

            clearFieldError(input) {
                const errorDiv = input.parentElement.parentElement.querySelector('.error-message');
                if (errorDiv) {
                    errorDiv.remove();
                }
                input.classList.remove('is-invalid');
            }

            showStatInfo(statType, statCard) {
                const statValue = statCard.querySelector('.stat-value').textContent;
                const statLabel = statCard.querySelector('.stat-label').textContent;

                let message = '';
                switch(statType) {
                    case 'users':
                        message = `${statValue} کاربر در پلتفرم ما عضو هستند`;
                        break;
                    case 'locations':
                        message = `${statValue} مکان جذاب در پلتفرم ثبت شده است`;
                        break;
                    case 'ratings':
                        message = `${statValue} نظر و امتیاز توسط کاربران ثبت شده`;
                        break;
                    case 'online':
                        message = `${statValue} کاربر در حال حاضر آنلاین هستند`;
                        break;
                    default:
                        message = `${statLabel}: ${statValue}`;
                }

                this.showNotification(message, 'info');
            }

            addSubmitAnimation() {
                // Enhanced submit animation
                const ripple = document.createElement('span');
                ripple.style.cssText = `
                    position: absolute;
                    border-radius: 50%;
                    background: rgba(255, 255, 255, 0.6);
                    transform: scale(0);
                    animation: ripple 0.6s linear;
                    pointer-events: none;
                    width: 100px;
                    height: 100px;
                    left: 50%;
                    top: 50%;
                    margin-left: -50px;
                    margin-top: -50px;
                `;

                this.submitBtn.appendChild(ripple);

                setTimeout(() => {
                    ripple.remove();
                }, 600);
            }

            animatePageLoad() {
                // Animate stats cards
                const statCards = document.querySelectorAll('.stat-card');
                statCards.forEach((card, index) => {
                    card.style.opacity = '0';
                    card.style.transform = 'translateY(20px)';

                    setTimeout(() => {
                        card.style.transition = 'all 0.6s cubic-bezier(0.4, 0, 0.2, 1)';
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, 200 + (index * 100));
                });

                // Animate form elements
                const formGroups = document.querySelectorAll('.form-group');
                formGroups.forEach((group, index) => {
                    group.style.opacity = '0';
                    group.style.transform = 'translateX(20px)';

                    setTimeout(() => {
                        group.style.transition = 'all 0.6s cubic-bezier(0.4, 0, 0.2, 1)';
                        group.style.opacity = '1';
                        group.style.transform = 'translateX(0)';
                    }, 400 + (index * 150));
                });
            }

            startStatsAnimation() {
                // Animate stat values counting up
                const statValues = document.querySelectorAll('.stat-value');
                statValues.forEach(stat => {
                    const finalValue = parseInt(stat.textContent.replace(/,/g, ''));
                    if (finalValue > 0) {
                        this.animateCounter(stat, 0, finalValue, 2000);
                    }
                });

                // Animate growth percentage
                const growthValue = document.querySelector('.growth-value');
                if (growthValue) {
                    const finalValue = parseFloat(growthValue.textContent.replace(/[+%]/g, ''));
                    if (finalValue > 0) {
                        this.animateCounter(growthValue, 0, finalValue, 1500, '+', '%');
                    }
                }
            }

            animateCounter(element, start, end, duration, prefix = '', suffix = '') {
                const startTime = performance.now();
                const originalText = element.textContent;

                const animate = (currentTime) => {
                    const elapsed = currentTime - startTime;
                    const progress = Math.min(elapsed / duration, 1);

                    const current = Math.floor(start + (end - start) * this.easeOutCubic(progress));
                    element.textContent = prefix + this.formatNumber(current) + suffix;

                    if (progress < 1) {
                        requestAnimationFrame(animate);
                    } else {
                        element.textContent = originalText; // Restore original formatting
                    }
                };

                requestAnimationFrame(animate);
            }

            formatNumber(num) {
                return num.toLocaleString('fa-IR');
            }

            easeOutCubic(t) {
                return 1 - Math.pow(1 - t, 3);
            }

            showError(message) {
                this.showNotification(message, 'error');
            }

            showSuccess(message) {
                this.showNotification(message, 'success');
            }

            showNotification(message, type) {
                const notification = document.createElement('div');
                notification.className = `alert alert-${type === 'error' ? 'danger' : type}`;
                notification.innerHTML = `<i class="fas fa-${type === 'success' ? 'check' : type === 'error' ? 'exclamation' : 'info'}-circle"></i> ${message}`;

                // Insert at top of form container
                const formContainer = document.querySelector('.login-form-container');
                formContainer.insertBefore(notification, formContainer.firstChild);

                setTimeout(() => {
                    notification.remove();
                }, 5000);
            }
        }

        // Initialize when DOM is loaded
        document.addEventListener('DOMContentLoaded', () => {
            new ModernUserLogin();
            console.log('🚀 Modern User Login initialized');
        });

        // Developer info function
        function showDeveloperInfo() {
            const modal = document.createElement('div');
            modal.style.cssText = `
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.8);
                display: flex;
                align-items: center;
                justify-content: center;
                z-index: 10000;
                backdrop-filter: blur(8px);
                animation: fadeIn 0.3s ease;
            `;

            modal.innerHTML = `
                <div style="
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    border-radius: 20px;
                    padding: 2rem;
                    text-align: center;
                    color: white;
                    max-width: 400px;
                    width: 90%;
                    box-shadow: 0 20px 40px rgba(0,0,0,0.3);
                    transform: scale(0.9);
                    animation: modalPop 0.3s ease forwards;
                ">
                    <div style="font-size: 3rem; margin-bottom: 1rem;">🚀</div>
                    <h3 style="margin-bottom: 0.5rem; font-weight: 700;">یوسف رجستری</h3>
                    <p style="margin-bottom: 0.5rem; font-size: 1.1rem; color: #e0e7ff;">Yousof Rajestary</p>
                    <p style="margin-bottom: 1.5rem; opacity: 0.9;">Full-Stack Developer & UI/UX Designer</p>
                    <div style="background: rgba(255,255,255,0.1); border-radius: 12px; padding: 1rem; margin-bottom: 1.5rem;">
                        <p style="margin: 0; font-size: 0.9rem; line-height: 1.6;">
                            این سیستم مدیریت مکان‌ها از ایده اولیه تا پیاده‌سازی نهایی توسط یوسف رجستری طراحی و توسعه یافته است.
                            شامل طراحی رابط کاربری، توسعه Backend و Frontend، و بهینه‌سازی تجربه کاربری.
                        </p>
                    </div>
                    <button onclick="this.closest('div').parentElement.remove()" style="
                        background: rgba(255,255,255,0.2);
                        border: 1px solid rgba(255,255,255,0.3);
                        border-radius: 8px;
                        color: white;
                        padding: 0.5rem 1.5rem;
                        cursor: pointer;
                        transition: all 0.3s ease;
                    " onmouseover="this.style.background='rgba(255,255,255,0.3)'" onmouseout="this.style.background='rgba(255,255,255,0.2)'">
                        بستن
                    </button>
                </div>
            `;

            modal.onclick = (e) => {
                if (e.target === modal) modal.remove();
            };

            document.body.appendChild(modal);
        }

        // Add CSS animations
        const style = document.createElement('style');
        style.textContent = `
            @keyframes ripple {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }

            @keyframes checkboxCheck {
                0% { transform: scale(1); }
                50% { transform: scale(1.2); }
                100% { transform: scale(1); }
            }

            @keyframes checkboxUncheck {
                0% { transform: scale(1); }
                50% { transform: scale(0.8); }
                100% { transform: scale(1); }
            }

            @keyframes fadeIn {
                from { opacity: 0; }
                to { opacity: 1; }
            }

            @keyframes modalPop {
                from { transform: scale(0.9); opacity: 0; }
                to { transform: scale(1); opacity: 1; }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/user/auth/login.blade.php ENDPATH**/ ?>