<?php $__env->startSection('title', 'تحلیل عملکرد'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Modern Header Section -->
    <div class="performance-analytics-header">
        <div class="header-content">
            <div class="header-text">
                <h1 class="header-title">
                    <i class="fas fa-chart-bar me-3"></i>
                    تحلیل عملکرد
                </h1>
                <p class="header-subtitle">
                    نظارت و تحلیل جامع شاخص‌های کلیدی عملکرد (KPI) و بهره‌وری سیستم
                </p>
            </div>
            <div class="header-controls">
                <div class="btn-group me-2" role="group">
                    <button type="button" class="btn btn-outline-primary active" data-performance-view="overview">
                        <i class="fas fa-tachometer-alt me-1"></i>
                        نمای کلی
                    </button>
                    <button type="button" class="btn btn-outline-primary" data-performance-view="kpi">
                        <i class="fas fa-bullseye me-1"></i>
                        KPI
                    </button>
                    <button type="button" class="btn btn-outline-primary" data-performance-view="trends">
                        <i class="fas fa-chart-line me-1"></i>
                        روندها
                    </button>
                    <button type="button" class="btn btn-outline-primary" data-performance-view="benchmarks">
                        <i class="fas fa-medal me-1"></i>
                        معیارها
                    </button>
                </div>
                <div class="dropdown">
                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-cog me-1"></i>
                        تنظیمات
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#" onclick="refreshPerformanceData()">
                            <i class="fas fa-sync me-2"></i>بروزرسانی داده‌ها
                        </a></li>
                        <li><a class="dropdown-item" href="#" onclick="exportPerformanceData('excel')">
                            <i class="fas fa-file-excel me-2"></i>خروجی Excel
                        </a></li>
                        <li><a class="dropdown-item" href="#" onclick="exportPerformanceData('pdf')">
                            <i class="fas fa-file-pdf me-2"></i>گزارش PDF
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="#" onclick="showPerformanceSettings()">
                            <i class="fas fa-sliders-h me-2"></i>تنظیمات نمایش
                        </a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced KPI Cards -->
    <div class="row mb-4" id="performance-kpi-cards">
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="performance-kpi-card">
                <div class="card-icon bg-primary">
                    <i class="fas fa-map-marker-alt"></i>
                </div>
                <div class="card-content">
                    <div class="card-value"><?php echo e($kpiMetrics['location_metrics']['current'] ?? 0); ?></div>
                    <div class="card-label">مکان‌های جدید</div>
                    <div class="card-trend <?php echo e($kpiMetrics['location_metrics']['growth'] >= 0 ? 'positive' : 'negative'); ?>">
                        <i class="fas fa-<?php echo e($kpiMetrics['location_metrics']['growth'] >= 0 ? 'arrow-up' : 'arrow-down'); ?> me-1"></i>
                        <?php echo e($kpiMetrics['location_metrics']['growth'] ?? 0); ?>% نسبت به دوره قبل
                    </div>
                </div>
                <div class="card-progress">
                    <div class="progress-bar" style="width: <?php echo e(min(100, abs($kpiMetrics['location_metrics']['growth'] ?? 0))); ?>%"></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="performance-kpi-card">
                <div class="card-icon bg-success">
                    <i class="fas fa-star"></i>
                </div>
                <div class="card-content">
                    <div class="card-value"><?php echo e($kpiMetrics['rating_metrics']['current'] ?? 0); ?></div>
                    <div class="card-label">نظرات جدید</div>
                    <div class="card-trend <?php echo e($kpiMetrics['rating_metrics']['growth'] >= 0 ? 'positive' : 'negative'); ?>">
                        <i class="fas fa-<?php echo e($kpiMetrics['rating_metrics']['growth'] >= 0 ? 'arrow-up' : 'arrow-down'); ?> me-1"></i>
                        <?php echo e($kpiMetrics['rating_metrics']['growth'] ?? 0); ?>% نسبت به دوره قبل
                    </div>
                </div>
                <div class="card-progress">
                    <div class="progress-bar" style="width: <?php echo e(min(100, abs($kpiMetrics['rating_metrics']['growth'] ?? 0))); ?>%"></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="performance-kpi-card">
                <div class="card-icon bg-info">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="card-content">
                    <div class="card-value"><?php echo e(number_format($kpiMetrics['avg_rating_metrics']['current'] ?? 0, 1)); ?></div>
                    <div class="card-label">میانگین امتیاز</div>
                    <div class="card-trend <?php echo e($kpiMetrics['avg_rating_metrics']['growth'] >= 0 ? 'positive' : 'negative'); ?>">
                        <i class="fas fa-<?php echo e($kpiMetrics['avg_rating_metrics']['growth'] >= 0 ? 'arrow-up' : 'arrow-down'); ?> me-1"></i>
                        <?php echo e($kpiMetrics['avg_rating_metrics']['growth'] ?? 0); ?>% نسبت به دوره قبل
                    </div>
                </div>
                <div class="card-progress">
                    <div class="progress-bar" style="width: <?php echo e(($kpiMetrics['avg_rating_metrics']['current'] ?? 0) * 20); ?>%"></div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="performance-kpi-card">
                <div class="card-icon bg-warning">
                    <i class="fas fa-percentage"></i>
                </div>
                <div class="card-content">
                    <div class="card-value"><?php echo e($conversionMetrics['average_ctr'] ?? 0); ?>%</div>
                    <div class="card-label">نرخ تبدیل</div>
                    <div class="card-trend neutral">
                        <i class="fas fa-chart-bar me-1"></i>
                        <?php echo e($conversionMetrics['total_clicks'] ?? 0); ?> از <?php echo e($conversionMetrics['total_views'] ?? 0); ?>

                    </div>
                </div>
                <div class="card-progress">
                    <div class="progress-bar" style="width: <?php echo e($conversionMetrics['average_ctr'] ?? 0); ?>%"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Overview Section -->
    <div class="performance-view" id="overview-view">
        <div class="row">
            <div class="col-lg-8 mb-4">
                <div class="performance-chart-card">
                    <div class="chart-header">
                        <div class="chart-title">
                            <h5 class="mb-1">
                                <i class="fas fa-chart-area text-primary me-2"></i>
                                روند عملکرد کلی
                            </h5>
                            <p class="text-muted mb-0">نمایش روند شاخص‌های کلیدی در 30 روز گذشته</p>
                        </div>
                        <div class="chart-actions">
                            <div class="btn-group btn-group-sm">
                                <button class="btn btn-outline-secondary active" onclick="togglePerformancePeriod('7')">
                                    7 روز
                                </button>
                                <button class="btn btn-outline-secondary" onclick="togglePerformancePeriod('30')">
                                    30 روز
                                </button>
                                <button class="btn btn-outline-secondary" onclick="togglePerformancePeriod('90')">
                                    90 روز
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="chart-body">
                        <div id="performance-overview-chart" class="chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 mb-4">
                <div class="performance-summary-card">
                    <div class="summary-header">
                        <h6 class="mb-0">
                            <i class="fas fa-clipboard-list text-success me-2"></i>
                            خلاصه عملکرد
                        </h6>
                    </div>
                    <div class="summary-body">
                        <div class="summary-item">
                            <div class="summary-icon bg-primary">
                                <i class="fas fa-trophy"></i>
                            </div>
                            <div class="summary-content">
                                <div class="summary-value"><?php echo e($performanceScore ?? 85); ?>%</div>
                                <div class="summary-label">امتیاز کلی عملکرد</div>
                            </div>
                        </div>
                        <div class="summary-item">
                            <div class="summary-icon bg-success">
                                <i class="fas fa-thumbs-up"></i>
                            </div>
                            <div class="summary-content">
                                <div class="summary-value"><?php echo e($satisfactionRate ?? 92); ?>%</div>
                                <div class="summary-label">نرخ رضایت</div>
                            </div>
                        </div>
                        <div class="summary-item">
                            <div class="summary-icon bg-info">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="summary-content">
                                <div class="summary-value"><?php echo e($responseTime ?? 1.2); ?>s</div>
                                <div class="summary-label">زمان پاسخ میانگین</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- KPI Section -->
    <div class="performance-view d-none" id="kpi-view">
        <div class="row">
            <div class="col-lg-6 mb-4">
                <div class="performance-chart-card">
                    <div class="chart-header">
                        <div class="chart-title">
                            <h5 class="mb-1">
                                <i class="fas fa-bullseye text-danger me-2"></i>
                                شاخص‌های کلیدی عملکرد
                            </h5>
                            <p class="text-muted mb-0">مقایسه KPI های اصلی با اهداف تعریف شده</p>
                        </div>
                    </div>
                    <div class="chart-body">
                        <div id="kpi-chart" class="chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 mb-4">
                <div class="performance-chart-card">
                    <div class="chart-header">
                        <div class="chart-title">
                            <h5 class="mb-1">
                                <i class="fas fa-chart-pie text-warning me-2"></i>
                                توزیع عملکرد دسته‌بندی‌ها
                            </h5>
                            <p class="text-muted mb-0">عملکرد هر دسته‌بندی نسبت به کل</p>
                        </div>
                    </div>
                    <div class="chart-body">
                        <div id="category-performance-chart" class="chart-container"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 mb-4">
                <div class="kpi-metrics-card">
                    <div class="metrics-header">
                        <h6 class="mb-0">
                            <i class="fas fa-tachometer-alt text-primary me-2"></i>
                            جدول شاخص‌های عملکرد
                        </h6>
                    </div>
                    <div class="metrics-body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="kpi-metric">
                                    <div class="metric-icon bg-primary">
                                        <i class="fas fa-users"></i>
                                    </div>
                                    <div class="metric-content">
                                        <div class="metric-value"><?php echo e($kpiMetrics['user_engagement'] ?? 78); ?>%</div>
                                        <div class="metric-label">تعامل کاربران</div>
                                        <div class="metric-target">هدف: 80%</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="kpi-metric">
                                    <div class="metric-icon bg-success">
                                        <i class="fas fa-chart-line"></i>
                                    </div>
                                    <div class="metric-content">
                                        <div class="metric-value"><?php echo e($kpiMetrics['growth_rate'] ?? 15); ?>%</div>
                                        <div class="metric-label">نرخ رشد</div>
                                        <div class="metric-target">هدف: 12%</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="kpi-metric">
                                    <div class="metric-icon bg-info">
                                        <i class="fas fa-star"></i>
                                    </div>
                                    <div class="metric-content">
                                        <div class="metric-value"><?php echo e($kpiMetrics['quality_score'] ?? 4.2); ?></div>
                                        <div class="metric-label">امتیاز کیفیت</div>
                                        <div class="metric-target">هدف: 4.0</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="kpi-metric">
                                    <div class="metric-icon bg-warning">
                                        <i class="fas fa-clock"></i>
                                    </div>
                                    <div class="metric-content">
                                        <div class="metric-value"><?php echo e($kpiMetrics['efficiency'] ?? 89); ?>%</div>
                                        <div class="metric-label">کارایی</div>
                                        <div class="metric-target">هدف: 85%</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Trends Section -->
    <div class="performance-view d-none" id="trends-view">
        <div class="row">
            <div class="col-lg-8 mb-4">
                <div class="performance-chart-card">
                    <div class="chart-header">
                        <div class="chart-title">
                            <h5 class="mb-1">
                                <i class="fas fa-chart-line text-success me-2"></i>
                                تحلیل روند عملکرد
                            </h5>
                            <p class="text-muted mb-0">روند تغییرات شاخص‌های عملکرد در زمان</p>
                        </div>
                        <div class="chart-actions">
                            <div class="btn-group btn-group-sm">
                                <button class="btn btn-outline-secondary active" onclick="toggleTrendMetric('all')">
                                    همه
                                </button>
                                <button class="btn btn-outline-secondary" onclick="toggleTrendMetric('locations')">
                                    مکان‌ها
                                </button>
                                <button class="btn btn-outline-secondary" onclick="toggleTrendMetric('ratings')">
                                    نظرات
                                </button>
                                <button class="btn btn-outline-secondary" onclick="toggleTrendMetric('quality')">
                                    کیفیت
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="chart-body">
                        <div id="trends-chart" class="chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 mb-4">
                <div class="trend-analysis-card">
                    <div class="analysis-header">
                        <h6 class="mb-0">
                            <i class="fas fa-search text-info me-2"></i>
                            تحلیل روند
                        </h6>
                    </div>
                    <div class="analysis-body">
                        <div class="trend-insight">
                            <div class="insight-icon bg-success">
                                <i class="fas fa-arrow-up"></i>
                            </div>
                            <div class="insight-content">
                                <div class="insight-title">روند صعودی</div>
                                <div class="insight-text">عملکرد کلی در 30 روز گذشته رشد <?php echo e($trendAnalysis['growth_percentage'] ?? 12); ?>% داشته</div>
                            </div>
                        </div>
                        <div class="trend-insight">
                            <div class="insight-icon bg-info">
                                <i class="fas fa-chart-bar"></i>
                            </div>
                            <div class="insight-content">
                                <div class="insight-title">بهترین عملکرد</div>
                                <div class="insight-text"><?php echo e($trendAnalysis['best_category'] ?? 'رستوران‌ها'); ?> بیشترین رشد را داشته‌اند</div>
                            </div>
                        </div>
                        <div class="trend-insight">
                            <div class="insight-icon bg-warning">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <div class="insight-content">
                                <div class="insight-title">نیاز به توجه</div>
                                <div class="insight-text"><?php echo e($trendAnalysis['attention_needed'] ?? 'هتل‌ها'); ?> نیاز به بهبود دارند</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Benchmarks Section -->
    <div class="performance-view d-none" id="benchmarks-view">
        <div class="row">
            <div class="col-lg-6 mb-4">
                <div class="performance-chart-card">
                    <div class="chart-header">
                        <div class="chart-title">
                            <h5 class="mb-1">
                                <i class="fas fa-medal text-warning me-2"></i>
                                مقایسه با معیارهای صنعت
                            </h5>
                            <p class="text-muted mb-0">مقایسه عملکرد با استانداردهای صنعت</p>
                        </div>
                    </div>
                    <div class="chart-body">
                        <div id="benchmarks-chart" class="chart-container"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 mb-4">
                <div class="benchmarks-table-card">
                    <div class="table-header">
                        <h6 class="mb-0">
                            <i class="fas fa-table text-primary me-2"></i>
                            جدول معیارها
                        </h6>
                    </div>
                    <div class="table-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>شاخص</th>
                                        <th>عملکرد ما</th>
                                        <th>معیار صنعت</th>
                                        <th>وضعیت</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>نرخ رضایت</td>
                                        <td><?php echo e($benchmarks['satisfaction_rate'] ?? 92); ?>%</td>
                                        <td>85%</td>
                                        <td><span class="badge bg-success">عالی</span></td>
                                    </tr>
                                    <tr>
                                        <td>زمان پاسخ</td>
                                        <td><?php echo e($benchmarks['response_time'] ?? 1.2); ?>s</td>
                                        <td>2.0s</td>
                                        <td><span class="badge bg-success">عالی</span></td>
                                    </tr>
                                    <tr>
                                        <td>نرخ تبدیل</td>
                                        <td><?php echo e($benchmarks['conversion_rate'] ?? 3.5); ?>%</td>
                                        <td>4.0%</td>
                                        <td><span class="badge bg-warning">نیاز به بهبود</span></td>
                                    </tr>
                                    <tr>
                                        <td>کیفیت محتوا</td>
                                        <td><?php echo e($benchmarks['content_quality'] ?? 4.2); ?>/5</td>
                                        <td>4.0/5</td>
                                        <td><span class="badge bg-success">عالی</span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Alerts and Insights -->
    <div class="row">
        <div class="col-lg-6 mb-4">
            <div class="alerts-card">
                <div class="alerts-header">
                    <h6 class="mb-0">
                        <i class="fas fa-bell text-danger me-2"></i>
                        هشدارها و اعلان‌ها
                    </h6>
                </div>
                <div class="alerts-body">
                    <?php if(isset($alerts) && count($alerts) > 0): ?>
                        <?php $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="alert-item alert-<?php echo e($alert['type']); ?>">
                            <div class="alert-icon">
                                <i class="fas fa-<?php echo e($alert['icon']); ?>"></i>
                            </div>
                            <div class="alert-content">
                                <div class="alert-title"><?php echo e($alert['title']); ?></div>
                                <div class="alert-message"><?php echo e($alert['message']); ?></div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="no-alerts">
                            <i class="fas fa-check-circle text-success"></i>
                            <p>همه شاخص‌ها در وضعیت مطلوب هستند</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-4">
            <div class="insights-card">
                <div class="insights-header">
                    <h6 class="mb-0">
                        <i class="fas fa-lightbulb text-warning me-2"></i>
                        بینش‌ها و پیشنهادات
                    </h6>
                </div>
                <div class="insights-body">
                    <?php if(isset($insights) && count($insights) > 0): ?>
                        <?php $__currentLoopData = $insights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="insight-item insight-<?php echo e($insight['type']); ?>">
                            <div class="insight-icon">
                                <i class="fas fa-<?php echo e($insight['icon']); ?>"></i>
                            </div>
                            <div class="insight-content">
                                <div class="insight-title"><?php echo e($insight['title']); ?></div>
                                <div class="insight-message"><?php echo e($insight['content']); ?></div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="no-insights">
                            <i class="fas fa-chart-line text-info"></i>
                            <p>در حال تحلیل داده‌ها برای ارائه بینش‌های جدید...</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Advanced Settings Panel -->
    <div class="performance-settings-panel d-none" id="performance-settings">
        <div class="settings-header">
            <h6 class="mb-0">
                <i class="fas fa-sliders-h me-2"></i>
                تنظیمات نمایش عملکرد
            </h6>
            <button class="btn btn-sm btn-outline-secondary" onclick="hidePerformanceSettings()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="settings-body">
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label">بازه زمانی</label>
                    <select class="form-select" id="performance-period">
                        <option value="7">7 روز گذشته</option>
                        <option value="30" selected>30 روز گذشته</option>
                        <option value="90">90 روز گذشته</option>
                        <option value="365">یک سال گذشته</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">نوع نمایش</label>
                    <select class="form-select" id="chart-type">
                        <option value="line">خطی</option>
                        <option value="bar">ستونی</option>
                        <option value="area" selected>ناحیه‌ای</option>
                        <option value="mixed">ترکیبی</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">شاخص‌های نمایش</label>
                    <select class="form-select" id="metrics-display">
                        <option value="all" selected>همه شاخص‌ها</option>
                        <option value="kpi">فقط KPI</option>
                        <option value="trends">فقط روندها</option>
                        <option value="custom">سفارشی</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">مقایسه</label>
                    <select class="form-select" id="comparison-mode">
                        <option value="none">بدون مقایسه</option>
                        <option value="previous" selected>دوره قبل</option>
                        <option value="benchmark">معیارهای صنعت</option>
                        <option value="target">اهداف تعریف شده</option>
                    </select>
                </div>
            </div>
            <div class="settings-actions mt-3">
                <button class="btn btn-primary" onclick="applyPerformanceSettings()">
                    <i class="fas fa-check me-1"></i>
                    اعمال تنظیمات
                </button>
                <button class="btn btn-outline-secondary" onclick="resetPerformanceSettings()">
                    <i class="fas fa-undo me-1"></i>
                    بازنشانی
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    /* Modern Performance Analytics Styles */
    .performance-analytics-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        padding: 2rem;
        margin-bottom: 2rem;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .performance-analytics-header::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 100%;
        height: 100%;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="performance" width="40" height="40" patternUnits="userSpaceOnUse"><rect width="40" height="40" fill="none"/><circle cx="20" cy="20" r="2" fill="white" opacity="0.1"/><rect x="15" y="15" width="10" height="10" fill="none" stroke="white" stroke-width="0.5" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23performance)"/></svg>');
        pointer-events: none;
    }

    .header-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: relative;
        z-index: 1;
    }

    .header-title {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .header-subtitle {
        font-size: 1.1rem;
        opacity: 0.9;
        margin-bottom: 0;
        line-height: 1.5;
    }

    .header-controls .btn {
        margin-left: 0.5rem;
        border-color: rgba(255,255,255,0.3);
        color: white;
        backdrop-filter: blur(10px);
        transition: all 0.3s ease;
    }

    .header-controls .btn:hover {
        background: rgba(255,255,255,0.2);
        border-color: rgba(255,255,255,0.5);
        transform: translateY(-2px);
    }

    .header-controls .btn.active {
        background: rgba(255,255,255,0.2);
        border-color: rgba(255,255,255,0.5);
    }

    /* Enhanced KPI Cards */
    .performance-kpi-card {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
        transition: all 0.3s ease;
        height: 100%;
        position: relative;
        overflow: hidden;
    }

    .performance-kpi-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    }

    .performance-kpi-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.12);
    }

    .performance-kpi-card .card-icon {
        width: 60px;
        height: 60px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        color: white;
        margin-bottom: 1rem;
        position: relative;
        z-index: 1;
    }

    .performance-kpi-card .card-content {
        position: relative;
        z-index: 1;
    }

    .performance-kpi-card .card-value {
        font-size: 2.2rem;
        font-weight: 700;
        color: #2c3e50;
        margin-bottom: 0.25rem;
    }

    .performance-kpi-card .card-label {
        font-size: 0.9rem;
        color: #6c757d;
        margin-bottom: 0.5rem;
        font-weight: 500;
    }

    .performance-kpi-card .card-trend {
        font-size: 0.8rem;
        font-weight: 500;
        display: flex;
        align-items: center;
        margin-bottom: 1rem;
    }

    .performance-kpi-card .card-trend.positive {
        color: #28a745;
    }

    .performance-kpi-card .card-trend.negative {
        color: #dc3545;
    }

    .performance-kpi-card .card-trend.neutral {
        color: #6c757d;
    }

    .performance-kpi-card .card-progress {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: #f0f0f0;
    }

    .performance-kpi-card .progress-bar {
        height: 100%;
        background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
        transition: width 0.3s ease;
    }

    /* Chart Cards */
    .performance-chart-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
        overflow: hidden;
        height: 100%;
    }

    .chart-header {
        padding: 1.5rem;
        border-bottom: 1px solid #f0f0f0;
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: linear-gradient(135deg, #fafbfc 0%, #f8f9fa 100%);
    }

    .chart-title h5 {
        color: #2c3e50;
        font-weight: 600;
        margin-bottom: 0.25rem;
    }

    .chart-title p {
        font-size: 0.9rem;
        margin-bottom: 0;
    }

    .chart-actions .btn {
        border-radius: 8px;
        padding: 0.5rem 0.75rem;
        transition: all 0.3s ease;
    }

    .chart-actions .btn.active {
        background: #667eea;
        border-color: #667eea;
        color: white;
    }

    .chart-body {
        padding: 1.5rem;
    }

    .chart-container {
        height: 350px;
        position: relative;
    }

    /* Summary Card */
    .performance-summary-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
        overflow: hidden;
        height: 100%;
    }

    .summary-header {
        padding: 1.5rem;
        border-bottom: 1px solid #f0f0f0;
        background: linear-gradient(135deg, #fafbfc 0%, #f8f9fa 100%);
    }

    .summary-body {
        padding: 1.5rem;
    }

    .summary-item {
        display: flex;
        align-items: center;
        gap: 1rem;
        margin-bottom: 1.5rem;
        padding: 1rem;
        background: #f8f9fa;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .summary-item:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }

    .summary-item:last-child {
        margin-bottom: 0;
    }

    .summary-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.2rem;
        flex-shrink: 0;
    }

    .summary-value {
        font-size: 1.5rem;
        font-weight: 700;
        color: #2c3e50;
        margin-bottom: 0.25rem;
    }

    .summary-label {
        font-size: 0.9rem;
        color: #6c757d;
    }

    /* KPI Metrics Card */
    .kpi-metrics-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
        overflow: hidden;
    }

    .metrics-header {
        padding: 1.5rem;
        border-bottom: 1px solid #f0f0f0;
        background: linear-gradient(135deg, #fafbfc 0%, #f8f9fa 100%);
    }

    .metrics-body {
        padding: 1.5rem;
    }

    .kpi-metric {
        display: flex;
        align-items: center;
        gap: 1rem;
        padding: 1.5rem;
        background: #f8f9fa;
        border-radius: 12px;
        transition: all 0.3s ease;
        margin-bottom: 1rem;
    }

    .kpi-metric:hover {
        background: #e9ecef;
        transform: translateY(-2px);
    }

    .kpi-metric:last-child {
        margin-bottom: 0;
    }

    .metric-icon {
        width: 60px;
        height: 60px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1.5rem;
        flex-shrink: 0;
    }

    .metric-value {
        font-size: 2rem;
        font-weight: 700;
        color: #2c3e50;
        margin-bottom: 0.25rem;
    }

    .metric-label {
        font-size: 1rem;
        color: #6c757d;
        margin-bottom: 0.25rem;
    }

    .metric-target {
        font-size: 0.8rem;
        color: #28a745;
        font-weight: 500;
    }

    /* Trend Analysis Card */
    .trend-analysis-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
        overflow: hidden;
        height: 100%;
    }

    .analysis-header {
        padding: 1.5rem;
        border-bottom: 1px solid #f0f0f0;
        background: linear-gradient(135deg, #fafbfc 0%, #f8f9fa 100%);
    }

    .analysis-body {
        padding: 1.5rem;
    }

    .trend-insight {
        display: flex;
        align-items: flex-start;
        gap: 1rem;
        margin-bottom: 1.5rem;
        padding: 1rem;
        background: #f8f9fa;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .trend-insight:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }

    .trend-insight:last-child {
        margin-bottom: 0;
    }

    .insight-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1rem;
        flex-shrink: 0;
    }

    .insight-title {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 0.25rem;
        font-size: 0.95rem;
    }

    .insight-text {
        color: #6c757d;
        font-size: 0.85rem;
        line-height: 1.4;
    }

    /* Benchmarks Table Card */
    .benchmarks-table-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
        overflow: hidden;
        height: 100%;
    }

    .table-header {
        padding: 1.5rem;
        border-bottom: 1px solid #f0f0f0;
        background: linear-gradient(135deg, #fafbfc 0%, #f8f9fa 100%);
    }

    .table-body {
        padding: 1.5rem;
    }

    .table-responsive {
        border-radius: 8px;
        overflow: hidden;
    }

    .table {
        margin-bottom: 0;
    }

    .table th {
        background: #f8f9fa;
        border: none;
        font-weight: 600;
        color: #2c3e50;
        padding: 1rem;
    }

    .table td {
        border: none;
        padding: 1rem;
        vertical-align: middle;
    }

    .table tbody tr:hover {
        background: #f8f9fa;
    }

    /* Alerts and Insights Cards */
    .alerts-card, .insights-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
        overflow: hidden;
        height: 100%;
    }

    .alerts-header, .insights-header {
        padding: 1.5rem;
        border-bottom: 1px solid #f0f0f0;
        background: linear-gradient(135deg, #fafbfc 0%, #f8f9fa 100%);
    }

    .alerts-body, .insights-body {
        padding: 1.5rem;
        max-height: 400px;
        overflow-y: auto;
    }

    .alert-item, .insight-item {
        display: flex;
        align-items: flex-start;
        gap: 1rem;
        margin-bottom: 1rem;
        padding: 1rem;
        border-radius: 12px;
        transition: all 0.3s ease;
    }

    .alert-item:hover, .insight-item:hover {
        transform: translateX(5px);
    }

    .alert-item:last-child, .insight-item:last-child {
        margin-bottom: 0;
    }

    .alert-item.alert-warning {
        background: #fff3cd;
        border-left: 4px solid #ffc107;
    }

    .alert-item.alert-danger {
        background: #f8d7da;
        border-left: 4px solid #dc3545;
    }

    .insight-item.insight-success {
        background: #d4edda;
        border-left: 4px solid #28a745;
    }

    .insight-item.insight-info {
        background: #d1ecf1;
        border-left: 4px solid #17a2b8;
    }

    .alert-icon, .insight-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 1rem;
        flex-shrink: 0;
    }

    .alert-title, .insight-title {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 0.25rem;
        font-size: 0.95rem;
    }

    .alert-message, .insight-message {
        color: #6c757d;
        font-size: 0.85rem;
        line-height: 1.4;
    }

    .no-alerts, .no-insights {
        text-align: center;
        padding: 2rem;
        color: #6c757d;
    }

    .no-alerts i, .no-insights i {
        font-size: 3rem;
        margin-bottom: 1rem;
    }

    /* Settings Panel */
    .performance-settings-panel {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
        margin-bottom: 2rem;
        overflow: hidden;
    }

    .settings-header {
        padding: 1rem 1.5rem;
        border-bottom: 1px solid #f0f0f0;
        background: linear-gradient(135deg, #fafbfc 0%, #f8f9fa 100%);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .settings-body {
        padding: 1.5rem;
    }

    .settings-actions {
        display: flex;
        gap: 1rem;
    }

    /* View Management */
    .performance-view {
        animation: fadeIn 0.3s ease;
    }

    .performance-view.d-none {
        display: none !important;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .header-content {
            flex-direction: column;
            gap: 1rem;
        }

        .header-controls {
            width: 100%;
            justify-content: center;
        }

        .header-controls .btn-group {
            flex-wrap: wrap;
        }

        .performance-kpi-card {
            text-align: center;
        }

        .chart-header {
            flex-direction: column;
            gap: 1rem;
            align-items: flex-start;
        }

        .kpi-metric {
            flex-direction: column;
            text-align: center;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/apexcharts@latest"></script>
<script>
// Performance Analytics Script - Isolated from other analytics scripts
(function() {
    'use strict';

    // Prevent conflicts with other analytics scripts
    if (window.performanceAnalyticsLoaded) {
        return;
    }
    window.performanceAnalyticsLoaded = true;

document.addEventListener('DOMContentLoaded', function() {
    // Performance data from backend
    const kpiMetrics = <?php echo json_encode($kpiMetrics ?? [], 15, 512) ?>;
    const performanceTrends = <?php echo json_encode($performanceTrends ?? [], 15, 512) ?>;
    const categoryPerformance = <?php echo json_encode($categoryPerformance ?? [], 15, 512) ?>;
    const conversionMetrics = <?php echo json_encode($conversionMetrics ?? [], 15, 512) ?>;

    // Initialize the page
    initPerformanceAnalytics();

    function initPerformanceAnalytics() {
        // Initialize view management
        initViewManagement();

        // Initialize charts
        initPerformanceOverviewChart();
        initKPIChart();
        initCategoryPerformanceChart();
        initTrendsChart();
        initBenchmarksChart();

        // Initialize real-time updates
        initRealTimeUpdates();
    }

    function initViewManagement() {
        // Handle view switching
        document.querySelectorAll('[data-performance-view]').forEach(button => {
            button.addEventListener('click', function() {
                const viewType = this.getAttribute('data-performance-view');
                switchPerformanceView(viewType);

                // Update active button
                document.querySelectorAll('[data-performance-view]').forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');
            });
        });
    }

    function switchPerformanceView(viewType) {
        // Hide all views
        document.querySelectorAll('.performance-view').forEach(view => {
            view.classList.add('d-none');
        });

        // Show selected view
        const targetView = document.getElementById(viewType + '-view');
        if (targetView) {
            targetView.classList.remove('d-none');
        }
    }

    function initPerformanceOverviewChart() {
        const dates = performanceTrends.dates || [];
        const locations = performanceTrends.locations || [];
        const ratings = performanceTrends.ratings || [];
        const avgRatings = performanceTrends.avg_ratings || [];

        const options = {
            series: [{
                name: 'مکان‌های جدید',
                type: 'column',
                data: locations
            }, {
                name: 'نظرات جدید',
                type: 'column',
                data: ratings
            }, {
                name: 'میانگین امتیاز',
                type: 'line',
                data: avgRatings
            }],
            chart: {
                height: 350,
                type: 'line',
                fontFamily: 'IRANSans, tahoma, sans-serif',
                toolbar: {
                    show: false
                },
                animations: {
                    enabled: true,
                    easing: 'easeinout',
                    speed: 800
                }
            },
            stroke: {
                width: [0, 0, 4],
                curve: 'smooth'
            },
            plotOptions: {
                bar: {
                    columnWidth: '50%'
                }
            },
            fill: {
                opacity: [0.85, 0.85, 1],
                gradient: {
                    inverseColors: false,
                    shade: 'light',
                    type: "vertical",
                    opacityFrom: 0.85,
                    opacityTo: 0.55,
                    stops: [0, 100, 100, 100]
                }
            },
            labels: dates,
            markers: {
                size: 0
            },
            xaxis: {
                type: 'category',
                labels: {
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            },
            yaxis: [{
                title: {
                    text: 'تعداد',
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            }, {
                opposite: true,
                title: {
                    text: 'میانگین امتیاز',
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            }],
            colors: ['#667eea', '#28a745', '#ffc107'],
            tooltip: {
                shared: true,
                intersect: false,
                y: {
                    formatter: function (val) {
                        return val + " مورد";
                    }
                }
            },
            legend: {
                position: 'top',
                fontFamily: 'IRANSans, tahoma, sans-serif'
            }
        };

        const chart = new ApexCharts(document.querySelector("#performance-overview-chart"), options);
        chart.render();
        window.performanceOverviewChart = chart;
    }

    function initKPIChart() {
        const kpiData = [
            { name: 'تعامل کاربران', value: kpiMetrics.user_engagement || 78, target: 80 },
            { name: 'نرخ رشد', value: kpiMetrics.growth_rate || 15, target: 12 },
            { name: 'امتیاز کیفیت', value: (kpiMetrics.quality_score || 4.2) * 20, target: 80 },
            { name: 'کارایی', value: kpiMetrics.efficiency || 89, target: 85 }
        ];

        const options = {
            series: [{
                name: 'عملکرد فعلی',
                data: kpiData.map(item => item.value)
            }, {
                name: 'هدف',
                data: kpiData.map(item => item.target)
            }],
            chart: {
                type: 'bar',
                height: 350,
                fontFamily: 'IRANSans, tahoma, sans-serif',
                toolbar: {
                    show: false
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '55%',
                    endingShape: 'rounded'
                }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                show: true,
                width: 2,
                colors: ['transparent']
            },
            xaxis: {
                categories: kpiData.map(item => item.name),
                labels: {
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            },
            yaxis: {
                title: {
                    text: 'درصد',
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            },
            fill: {
                opacity: 1
            },
            colors: ['#667eea', '#28a745'],
            tooltip: {
                y: {
                    formatter: function (val) {
                        return val + "%";
                    }
                }
            }
        };

        const chart = new ApexCharts(document.querySelector("#kpi-chart"), options);
        chart.render();
        window.kpiChart = chart;
    }

    function initCategoryPerformanceChart() {
        const categories = categoryPerformance.labels || [];
        const data = categoryPerformance.data || [];

        const options = {
            series: data,
            chart: {
                type: 'donut',
                height: 350,
                fontFamily: 'IRANSans, tahoma, sans-serif'
            },
            labels: categories,
            colors: ['#667eea', '#28a745', '#ffc107', '#dc3545', '#17a2b8'],
            plotOptions: {
                pie: {
                    donut: {
                        size: '70%',
                        labels: {
                            show: true,
                            total: {
                                show: true,
                                label: 'مجموع',
                                formatter: function (w) {
                                    return w.globals.seriesTotals.reduce((a, b) => {
                                        return a + b;
                                    }, 0);
                                }
                            }
                        }
                    }
                }
            },
            legend: {
                position: 'bottom',
                fontFamily: 'IRANSans, tahoma, sans-serif'
            },
            tooltip: {
                y: {
                    formatter: function (val) {
                        return val + " مورد";
                    }
                }
            }
        };

        const chart = new ApexCharts(document.querySelector("#category-performance-chart"), options);
        chart.render();
        window.categoryPerformanceChart = chart;
    }

    function initTrendsChart() {
        const dates = performanceTrends.dates || [];
        const locations = performanceTrends.locations || [];
        const ratings = performanceTrends.ratings || [];
        const avgRatings = performanceTrends.avg_ratings || [];

        const options = {
            series: [{
                name: 'مکان‌ها',
                data: locations
            }, {
                name: 'نظرات',
                data: ratings
            }, {
                name: 'کیفیت',
                data: avgRatings.map(rating => rating * 20) // Scale to percentage
            }],
            chart: {
                height: 350,
                type: 'area',
                fontFamily: 'IRANSans, tahoma, sans-serif',
                toolbar: {
                    show: false
                }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                curve: 'smooth',
                width: 3
            },
            xaxis: {
                categories: dates,
                labels: {
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            },
            yaxis: {
                title: {
                    text: 'مقدار',
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            },
            fill: {
                type: 'gradient',
                gradient: {
                    opacityFrom: 0.6,
                    opacityTo: 0.1
                }
            },
            colors: ['#667eea', '#28a745', '#ffc107'],
            tooltip: {
                y: {
                    formatter: function (val) {
                        return val + " مورد";
                    }
                }
            }
        };

        const chart = new ApexCharts(document.querySelector("#trends-chart"), options);
        chart.render();
        window.trendsChart = chart;
    }

    function initBenchmarksChart() {
        const benchmarkData = [
            { metric: 'نرخ رضایت', our: 92, industry: 85 },
            { metric: 'زمان پاسخ', our: 80, industry: 50 }, // Inverted scale for response time
            { metric: 'نرخ تبدیل', our: 3.5, industry: 4.0 },
            { metric: 'کیفیت محتوا', our: 84, industry: 80 }
        ];

        const options = {
            series: [{
                name: 'عملکرد ما',
                data: benchmarkData.map(item => item.our)
            }, {
                name: 'معیار صنعت',
                data: benchmarkData.map(item => item.industry)
            }],
            chart: {
                type: 'radar',
                height: 350,
                fontFamily: 'IRANSans, tahoma, sans-serif'
            },
            xaxis: {
                categories: benchmarkData.map(item => item.metric),
                labels: {
                    style: {
                        fontFamily: 'IRANSans, tahoma, sans-serif'
                    }
                }
            },
            colors: ['#667eea', '#dc3545'],
            markers: {
                size: 4
            },
            legend: {
                position: 'top',
                fontFamily: 'IRANSans, tahoma, sans-serif'
            }
        };

        const chart = new ApexCharts(document.querySelector("#benchmarks-chart"), options);
        chart.render();
        window.benchmarksChart = chart;
    }

    function initRealTimeUpdates() {
        // Simulate real-time updates every 30 seconds
        setInterval(() => {
            updateKPICards();
        }, 30000);
    }

    function updateKPICards() {
        // Simulate small random changes in KPI values
        const cards = document.querySelectorAll('.performance-kpi-card .card-value');
        cards.forEach(card => {
            const currentValue = parseInt(card.textContent);
            const change = Math.floor(Math.random() * 3) - 1; // -1, 0, or 1
            const newValue = Math.max(0, currentValue + change);

            if (newValue !== currentValue) {
                card.style.transition = 'all 0.3s ease';
                card.textContent = newValue;
                card.style.transform = 'scale(1.1)';

                setTimeout(() => {
                    card.style.transform = 'scale(1)';
                }, 300);
            }
        });
    }

    // Chart toggle functions
    window.togglePerformancePeriod = function(period) {
        console.log('Toggling performance period to:', period);

        // Update active button
        document.querySelectorAll('#overview-view .chart-actions .btn').forEach(btn => btn.classList.remove('active'));
        event.target.classList.add('active');

        showNotification(`نمایش داده‌های ${period} روز گذشته`, 'info');
    };

    window.toggleTrendMetric = function(metric) {
        console.log('Toggling trend metric to:', metric);

        // Update active button
        document.querySelectorAll('#trends-view .chart-actions .btn').forEach(btn => btn.classList.remove('active'));
        event.target.classList.add('active');

        if (window.trendsChart) {
            // Here you would update the chart with filtered data
            showNotification(`نمایش روند ${metric === 'all' ? 'همه شاخص‌ها' : metric}`, 'info');
        }
    };

    // Global functions for external use
    window.refreshPerformanceData = function() {
        console.log('Refreshing performance data...');
        showNotification('در حال بروزرسانی داده‌های عملکرد...', 'info');

        // Simulate refresh
        setTimeout(() => {
            showNotification('داده‌های عملکرد بروزرسانی شدند', 'success');
            location.reload();
        }, 2000);
    };

    window.exportPerformanceData = function(format) {
        console.log('Exporting performance data as:', format);
        showNotification(`در حال تهیه گزارش ${format.toUpperCase()}...`, 'info');

        // Simulate export
        setTimeout(() => {
            showNotification(`گزارش ${format.toUpperCase()} آماده دانلود است`, 'success');
        }, 2000);
    };

    window.showPerformanceSettings = function() {
        const settingsPanel = document.getElementById('performance-settings');
        if (settingsPanel) {
            settingsPanel.classList.remove('d-none');
        }
    };

    window.hidePerformanceSettings = function() {
        const settingsPanel = document.getElementById('performance-settings');
        if (settingsPanel) {
            settingsPanel.classList.add('d-none');
        }
    };

    window.applyPerformanceSettings = function() {
        const period = document.getElementById('performance-period').value;
        const chartType = document.getElementById('chart-type').value;
        const metricsDisplay = document.getElementById('metrics-display').value;
        const comparisonMode = document.getElementById('comparison-mode').value;

        console.log('Applying performance settings:', { period, chartType, metricsDisplay, comparisonMode });
        showNotification('تنظیمات اعمال شدند', 'success');

        // Hide settings panel
        hidePerformanceSettings();

        // Simulate settings application
        setTimeout(() => {
            location.reload();
        }, 1000);
    };

    window.resetPerformanceSettings = function() {
        document.getElementById('performance-period').value = '30';
        document.getElementById('chart-type').value = 'area';
        document.getElementById('metrics-display').value = 'all';
        document.getElementById('comparison-mode').value = 'previous';

        showNotification('تنظیمات بازنشانی شدند', 'success');
    };

    function showNotification(message, type = 'info') {
        const alertClass = type === 'success' ? 'alert-success' :
                         type === 'error' ? 'alert-danger' : 'alert-info';

        const notification = document.createElement('div');
        notification.className = `alert ${alertClass} alert-dismissible fade show position-fixed`;
        notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
        notification.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;

        document.body.appendChild(notification);

        setTimeout(() => {
            if (notification.parentNode) {
                notification.parentNode.removeChild(notification);
            }
        }, 3000);
    }
});

})(); // End of IIFE (Immediately Invoked Function Expression)
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/analytics/performance_modern.blade.php ENDPATH**/ ?>