

<?php $__env->startSection('title', 'نظرات من'); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/rating-comments.css')); ?>">
<style>
    /* Modern Ratings Page Styles */
    .ratings-container {
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
        min-height: 100vh;
        padding: 2rem 0;
    }

    .page-header {
        background: white;
        border-radius: 20px;
        padding: 2rem;
        margin-bottom: 2rem;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
        position: relative;
        overflow: hidden;
    }

    .page-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 100px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        z-index: 1;
    }

    .page-header-content {
        position: relative;
        z-index: 2;
        color: white;
        margin-top: 20px;
    }

    .page-title {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .page-subtitle {
        font-size: 1.1rem;
        opacity: 0.9;
        margin-bottom: 2rem;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1.5rem;
        margin-top: 2rem;
    }

    .stat-card {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        text-align: center;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        border: 1px solid rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(135deg, #667eea, #764ba2);
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
    }

    .stat-icon {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        margin: 0 auto 1rem;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 0.5rem;
    }

    .stat-label {
        color: #718096;
        font-size: 0.875rem;
        font-weight: 500;
    }

    .filters-section {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    }

    .filters-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #f1f5f9;
    }

    .filters-title {
        font-size: 1.25rem;
        font-weight: 700;
        color: #2d3748;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .filters-title-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.1rem;
    }

    .filter-group {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-bottom: 1rem;
    }

    .filter-item {
        position: relative;
    }

    .filter-label {
        display: block;
        font-weight: 600;
        color: #374151;
        margin-bottom: 0.5rem;
        font-size: 0.875rem;
    }

    .filter-input {
        width: 100%;
        padding: 0.875rem 1rem;
        border: 2px solid #e5e7eb;
        border-radius: 12px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: #f9fafb;
    }

    .filter-input:focus {
        outline: none;
        border-color: #667eea;
        background: white;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .filter-select {
        appearance: none;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3e%3c/svg%3e");
        background-position: left 0.75rem center;
        background-repeat: no-repeat;
        background-size: 1.5em 1.5em;
        padding-left: 3rem;
    }

    .search-container {
        position: relative;
        grid-column: 1 / -1;
    }

    .search-input {
        padding-left: 3rem;
    }

    .search-icon {
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
        font-size: 1.25rem;
    }

    .filter-actions {
        display: flex;
        gap: 1rem;
        justify-content: flex-end;
        margin-top: 1rem;
    }

    .modern-btn {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border: none;
        padding: 0.875rem 2rem;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        cursor: pointer;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        text-decoration: none;
    }

    .modern-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        color: white;
        text-decoration: none;
    }

    .modern-btn-secondary {
        background: #6b7280;
    }

    .modern-btn-secondary:hover {
        background: #4b5563;
        box-shadow: 0 8px 25px rgba(107, 114, 128, 0.3);
    }

    .modern-btn-outline {
        background: transparent;
        color: #667eea;
        border: 2px solid #667eea;
    }

    .modern-btn-outline:hover {
        background: #667eea;
        color: white;
    }

    .ratings-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(400px, 1fr));
        gap: 2rem;
        margin-bottom: 2rem;
    }

    .rating-card {
        background: white;
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
        position: relative;
        border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .rating-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
    }

    .rating-header {
        padding: 1.5rem;
        border-bottom: 1px solid #f1f5f9;
        position: relative;
    }

    .rating-status {
        position: absolute;
        top: 1rem;
        right: 1rem;
        padding: 0.5rem 1rem;
        border-radius: 25px;
        font-size: 0.75rem;
        font-weight: 600;
    }

    .status-approved {
        background: rgba(16, 185, 129, 0.1);
        color: #059669;
        border: 1px solid rgba(16, 185, 129, 0.2);
    }

    .status-pending {
        background: rgba(245, 158, 11, 0.1);
        color: #d97706;
        border: 1px solid rgba(245, 158, 11, 0.2);
    }

    .status-rejected {
        background: rgba(239, 68, 68, 0.1);
        color: #dc2626;
        border: 1px solid rgba(239, 68, 68, 0.2);
    }

    .rating-location {
        font-size: 1.25rem;
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 0.5rem;
        padding-right: 120px;
    }

    .rating-category {
        color: #718096;
        font-size: 0.875rem;
        margin-bottom: 1rem;
    }

    .rating-stars {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 1rem;
    }

    .stars {
        display: flex;
        gap: 0.25rem;
    }

    .star {
        font-size: 1.25rem;
        color: #fbbf24;
    }

    .star.empty {
        color: #e5e7eb;
    }

    .rating-value {
        font-size: 1.5rem;
        font-weight: 700;
        color: #667eea;
        margin-left: 0.5rem;
    }

    .rating-content {
        padding: 1.5rem;
    }

    .rating-comments {
        margin-bottom: 1.5rem;
    }

    .comment-section {
        margin-bottom: 1rem;
    }

    .comment-label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 0.5rem;
        font-size: 0.875rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .comment-text {
        color: #4a5568;
        font-size: 0.875rem;
        line-height: 1.6;
        background: #f8fafc;
        padding: 1rem;
        border-radius: 8px;
        border-left: 4px solid #667eea;
    }

    .rating-meta {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1rem 1.5rem;
        background: #f8fafc;
        border-top: 1px solid #f1f5f9;
    }

    .rating-date {
        color: #718096;
        font-size: 0.875rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .rating-actions {
        display: flex;
        gap: 0.75rem;
    }

    .action-btn {
        padding: 0.5rem 1rem;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        font-size: 0.875rem;
        cursor: pointer;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        text-decoration: none;
    }

    .action-btn-primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .action-btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        color: white;
        text-decoration: none;
    }

    .action-btn-secondary {
        background: #f8fafc;
        color: #4a5568;
        border: 1px solid #e2e8f0;
    }

    .action-btn-secondary:hover {
        background: #edf2f7;
        color: #2d3748;
        text-decoration: none;
    }

    .action-btn-danger {
        background: #fed7d7;
        color: #c53030;
        border: 1px solid #feb2b2;
    }

    .action-btn-danger:hover {
        background: #fc8181;
        color: white;
    }

    .empty-state {
        text-align: center;
        padding: 4rem 2rem;
        background: white;
        border-radius: 20px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    }

    .empty-state-icon {
        width: 120px;
        height: 120px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 3rem;
        margin: 0 auto 2rem;
    }

    .empty-state-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 1rem;
    }

    .empty-state-description {
        color: #718096;
        font-size: 1rem;
        margin-bottom: 2rem;
        max-width: 400px;
        margin-left: auto;
        margin-right: auto;
    }

    .pagination-container {
        display: flex;
        justify-content: center;
        margin-top: 3rem;
    }

    .loading-spinner {
        display: none;
        text-align: center;
        padding: 2rem;
    }

    .spinner {
        width: 40px;
        height: 40px;
        border: 4px solid #f3f4f6;
        border-top: 4px solid #667eea;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Chart Container */
    .chart-container {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    }

    .chart-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #f1f5f9;
    }

    .chart-title {
        font-size: 1.25rem;
        font-weight: 700;
        color: #2d3748;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .chart-title-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.1rem;
    }

    .chart-content {
        height: 300px;
        position: relative;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .ratings-container {
            padding: 1rem 0;
        }

        .page-header {
            margin: 1rem;
            padding: 1.5rem;
        }

        .page-title {
            font-size: 2rem;
        }

        .stats-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .filter-group {
            grid-template-columns: 1fr;
        }

        .ratings-grid {
            grid-template-columns: 1fr;
            gap: 1rem;
        }

        .filter-actions {
            flex-direction: column;
        }

        .rating-actions {
            flex-direction: column;
        }

        .rating-location {
            padding-right: 0;
            margin-bottom: 1rem;
        }

        .rating-status {
            position: static;
            display: inline-block;
            margin-bottom: 1rem;
        }
    }

    /* Animation */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .rating-card {
        animation: fadeInUp 0.6s ease forwards;
    }

    .rating-card:nth-child(1) { animation-delay: 0.1s; }
    .rating-card:nth-child(2) { animation-delay: 0.2s; }
    .rating-card:nth-child(3) { animation-delay: 0.3s; }
    .rating-card:nth-child(4) { animation-delay: 0.4s; }
    .rating-card:nth-child(5) { animation-delay: 0.5s; }
    .rating-card:nth-child(6) { animation-delay: 0.6s; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="ratings-container">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div class="page-header-content">
                <h1 class="page-title">نظرات من</h1>
                <p class="page-subtitle">مدیریت و نظارت بر نظرات ثبت شده توسط شما</p>

                <div class="d-flex justify-content-end">
                    <a href="<?php echo e(route('user.ratings.create')); ?>" class="modern-btn">
                        <i class="fas fa-plus"></i>
                        ثبت نظر جدید
                    </a>
                </div>
            </div>

            <!-- Statistics Grid -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-comment"></i>
                    </div>
                    <div class="stat-number"><?php echo e($stats['total']); ?></div>
                    <div class="stat-label">کل نظرات</div>
                </div>

                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="stat-number"><?php echo e($stats['approved']); ?></div>
                    <div class="stat-label">تایید شده</div>
                </div>

                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stat-number"><?php echo e($stats['pending']); ?></div>
                    <div class="stat-label">در انتظار تایید</div>
                </div>

                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-star"></i>
                    </div>
                    <div class="stat-number"><?php echo e($stats['avg_rating']); ?></div>
                    <div class="stat-label">میانگین امتیاز</div>
                </div>
            </div>
        </div>

        <!-- Filters Section -->
        <div class="filters-section">
            <div class="filters-header">
                <div class="filters-title">
                    <div class="filters-title-icon">
                        <i class="fas fa-filter"></i>
                    </div>
                    فیلتر و جستجو
                </div>

                <button type="button" class="modern-btn-outline" onclick="clearFilters()">
                    <i class="fas fa-times"></i>
                    پاک کردن فیلترها
                </button>
            </div>

            <form method="GET" action="<?php echo e(route('user.ratings.index')); ?>" id="filtersForm">
                <div class="filter-group">
                    <div class="search-container">
                        <div class="filter-item">
                            <label class="filter-label">جستجو در نظرات</label>
                            <input type="text"
                                   name="search"
                                   value="<?php echo e($search); ?>"
                                   class="filter-input search-input"
                                   placeholder="جستجو در نام مکان، نظرات...">
                            <i class="fas fa-search search-icon"></i>
                        </div>
                    </div>

                    <div class="filter-item">
                        <label class="filter-label">وضعیت</label>
                        <select name="status" class="filter-input filter-select">
                            <option value="all" <?php echo e($status == 'all' ? 'selected' : ''); ?>>همه وضعیت‌ها</option>
                            <option value="approved" <?php echo e($status == 'approved' ? 'selected' : ''); ?>>تایید شده</option>
                            <option value="pending" <?php echo e($status == 'pending' ? 'selected' : ''); ?>>در انتظار تایید</option>
                            <option value="rejected" <?php echo e($status == 'rejected' ? 'selected' : ''); ?>>رد شده</option>
                        </select>
                    </div>

                    <div class="filter-item">
                        <label class="filter-label">امتیاز</label>
                        <select name="rating_filter" class="filter-input filter-select">
                            <option value="">همه امتیازها</option>
                            <option value="5" <?php echo e($rating_filter == '5' ? 'selected' : ''); ?>>5 ستاره</option>
                            <option value="4" <?php echo e($rating_filter == '4' ? 'selected' : ''); ?>>4 ستاره</option>
                            <option value="3" <?php echo e($rating_filter == '3' ? 'selected' : ''); ?>>3 ستاره</option>
                            <option value="2" <?php echo e($rating_filter == '2' ? 'selected' : ''); ?>>2 ستاره</option>
                            <option value="1" <?php echo e($rating_filter == '1' ? 'selected' : ''); ?>>1 ستاره</option>
                        </select>
                    </div>

                    <div class="filter-item">
                        <label class="filter-label">مرتب‌سازی</label>
                        <select name="sort" class="filter-input filter-select">
                            <option value="newest" <?php echo e($sort == 'newest' ? 'selected' : ''); ?>>جدیدترین</option>
                            <option value="oldest" <?php echo e($sort == 'oldest' ? 'selected' : ''); ?>>قدیمی‌ترین</option>
                            <option value="rating_high" <?php echo e($sort == 'rating_high' ? 'selected' : ''); ?>>بالاترین امتیاز</option>
                            <option value="rating_low" <?php echo e($sort == 'rating_low' ? 'selected' : ''); ?>>پایین‌ترین امتیاز</option>
                            <option value="status" <?php echo e($sort == 'status' ? 'selected' : ''); ?>>بر اساس وضعیت</option>
                        </select>
                    </div>
                </div>

                <div class="filter-actions">
                    <button type="submit" class="modern-btn">
                        <i class="fas fa-search"></i>
                        اعمال فیلتر
                    </button>
                </div>
            </form>
        </div>

        <!-- Success/Error Messages -->
        <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>

        <!-- Ratings Grid -->
        <?php if($ratings->isEmpty()): ?>
        <div class="empty-state">
            <div class="empty-state-icon">
                <i class="fas fa-comment"></i>
            </div>
            <h2 class="empty-state-title">هنوز نظری ثبت نکرده‌اید</h2>
            <p class="empty-state-description">
                برای شروع، نظر خود را درباره مکان‌هایی که بازدید کرده‌اید ثبت کنید
            </p>
            <a href="<?php echo e(route('user.ratings.create')); ?>" class="modern-btn">
                <i class="fas fa-plus"></i>
                ثبت اولین نظر
            </a>
        </div>
        <?php else: ?>
        <div class="ratings-grid" id="ratingsGrid">
            <?php $__currentLoopData = $ratings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="rating-card">
                <!-- Rating Header -->
                <div class="rating-header">
                    <div class="rating-status status-<?php echo e($rating->status); ?>">
                        <?php switch($rating->status):
                            case ('approved'): ?>
                                <i class="fas fa-check"></i> تایید شده
                                <?php break; ?>
                            <?php case ('rejected'): ?>
                                <i class="fas fa-times"></i> رد شده
                                <?php break; ?>
                            <?php default: ?>
                                <i class="fas fa-clock"></i> در انتظار تایید
                        <?php endswitch; ?>
                    </div>

                    <h3 class="rating-location"><?php echo e($rating->hotel_name); ?></h3>
                    <div class="rating-category">
                        <i class="fas fa-tag"></i>
                        <?php echo e($rating->getLocalizedCategoryName()); ?>

                    </div>

                    <div class="rating-stars">
                        <div class="stars">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <i class="fas fa-star <?php echo e($i <= $rating->rating ? 'star' : 'star empty'); ?>"></i>
                            <?php endfor; ?>
                        </div>
                        <span class="rating-value"><?php echo e($rating->rating); ?>/5</span>
                    </div>
                </div>

                <!-- Rating Content -->
                <div class="rating-content">
                    <?php if($rating->positive_comment || $rating->negative_comment): ?>
                    <div class="rating-comments">
                        <?php if($rating->positive_comment): ?>
                        <div class="comment-section">
                            <div class="comment-label">
                                <i class="fas fa-thumbs-up text-success"></i>
                                نکات مثبت
                            </div>
                            <div class="comment-text positive-comments"><?php echo $rating->positive_comment; ?></div>
                        </div>
                        <?php endif; ?>

                        <?php if($rating->negative_comment): ?>
                        <div class="comment-section">
                            <div class="comment-label">
                                <i class="fas fa-thumbs-down text-danger"></i>
                                نکات منفی
                            </div>
                            <div class="comment-text negative-comments"><?php echo $rating->negative_comment; ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Rating Meta -->
                <div class="rating-meta">
                    <div class="rating-date">
                        <i class="fas fa-calendar"></i>
                        <?php echo e($rating->timestamp ? jdate($rating->timestamp)->format('Y/m/d H:i') : 'نامشخص'); ?>

                    </div>

                    <div class="rating-actions">
                        <a href="<?php echo e(route('user.ratings.show', $rating->id)); ?>" class="action-btn action-btn-primary">
                            <i class="fas fa-eye"></i>
                            مشاهده
                        </a>

                        <?php if($rating->status == 'pending'): ?>
                        <a href="<?php echo e(route('user.ratings.edit', $rating->id)); ?>" class="action-btn action-btn-secondary">
                            <i class="fas fa-edit"></i>
                            ویرایش
                        </a>

                        <form action="<?php echo e(route('user.ratings.destroy', $rating->id)); ?>" method="POST" class="d-inline" onsubmit="return confirmDelete(event, '<?php echo e($rating->hotel_name); ?>')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="action-btn action-btn-danger">
                                <i class="fas fa-trash"></i>
                                حذف
                            </button>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Loading Spinner -->
        <div class="loading-spinner" id="loadingSpinner">
            <div class="spinner"></div>
            <p class="mt-2">در حال بارگذاری...</p>
        </div>

        <!-- Pagination -->
        <div class="pagination-container">
            <?php echo e($ratings->appends(request()->query())->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Modern Ratings Manager
    class ModernRatingsManager {
        constructor() {
            this.init();
        }

        init() {
            this.initializeFilters();
            this.initializeSearch();
            this.initializeAnimations();
            this.initializeInfiniteScroll();
            this.initializeStatCounters();
        }

        // Initialize Filters
        initializeFilters() {
            const form = document.getElementById('filtersForm');
            const inputs = form.querySelectorAll('select, input');

            // Auto-submit on filter change
            inputs.forEach(input => {
                if (input.type !== 'text') {
                    input.addEventListener('change', () => {
                        this.submitFilters();
                    });
                }
            });

            // Search input with debounce
            const searchInput = form.querySelector('input[name="search"]');
            if (searchInput) {
                let searchTimeout;
                searchInput.addEventListener('input', () => {
                    clearTimeout(searchTimeout);
                    searchTimeout = setTimeout(() => {
                        this.submitFilters();
                    }, 500);
                });
            }
        }

        // Submit Filters
        submitFilters() {
            const form = document.getElementById('filtersForm');
            const formData = new FormData(form);
            const params = new URLSearchParams();

            for (let [key, value] of formData.entries()) {
                if (value) {
                    params.append(key, value);
                }
            }

            // Show loading
            this.showLoading();

            // Update URL and reload
            const newUrl = window.location.pathname + '?' + params.toString();
            window.location.href = newUrl;
        }

        // Clear Filters
        clearFilters() {
            const form = document.getElementById('filtersForm');
            form.reset();
            window.location.href = window.location.pathname;
        }

        // Initialize Search
        initializeSearch() {
            const searchInput = document.querySelector('input[name="search"]');
            if (searchInput) {
                searchInput.addEventListener('keypress', (e) => {
                    if (e.key === 'Enter') {
                        e.preventDefault();
                        this.submitFilters();
                    }
                });
            }
        }

        // Initialize Animations
        initializeAnimations() {
            // Animate stats on scroll
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        this.animateNumber(entry.target);
                        observer.unobserve(entry.target);
                    }
                });
            }, observerOptions);

            document.querySelectorAll('.stat-number').forEach(el => {
                observer.observe(el);
            });

            // Hover effects for cards
            document.querySelectorAll('.rating-card, .stat-card').forEach(card => {
                card.addEventListener('mouseenter', () => {
                    card.style.transform = 'translateY(-8px)';
                });

                card.addEventListener('mouseleave', () => {
                    card.style.transform = 'translateY(0)';
                });
            });
        }

        // Initialize Infinite Scroll
        initializeInfiniteScroll() {
            const nextPageUrl = document.querySelector('.pagination .page-link[rel="next"]')?.href;
            if (!nextPageUrl) return;

            let loading = false;

            window.addEventListener('scroll', () => {
                if (loading) return;

                const scrollTop = window.pageYOffset;
                const windowHeight = window.innerHeight;
                const documentHeight = document.documentElement.scrollHeight;

                if (scrollTop + windowHeight >= documentHeight - 1000) {
                    this.loadMoreRatings();
                    loading = true;
                }
            });
        }

        // Load More Ratings
        async loadMoreRatings() {
            const nextPageUrl = document.querySelector('.pagination .page-link[rel="next"]')?.href;
            if (!nextPageUrl) return;

            this.showLoading();

            try {
                const response = await fetch(nextPageUrl, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                });

                const data = await response.json();

                if (data.html) {
                    const grid = document.getElementById('ratingsGrid');
                    grid.insertAdjacentHTML('beforeend', data.html);

                    // Update pagination
                    if (data.nextPageUrl) {
                        document.querySelector('.pagination .page-link[rel="next"]').href = data.nextPageUrl;
                    } else {
                        document.querySelector('.pagination .page-link[rel="next"]')?.remove();
                    }

                    // Re-initialize animations for new cards
                    this.initializeAnimations();
                }
            } catch (error) {
                console.error('Error loading more ratings:', error);
                this.showNotification('خطا در بارگذاری نظرات', 'error');
            } finally {
                this.hideLoading();
            }
        }

        // Initialize Stat Counters
        initializeStatCounters() {
            document.querySelectorAll('.stat-number').forEach(el => {
                const finalNumber = parseFloat(el.textContent.replace(/[^\d.]/g, ''));
                if (finalNumber > 0) {
                    el.textContent = '0';
                    el.dataset.target = finalNumber;
                }
            });
        }

        // Animate Number
        animateNumber(element) {
            const target = parseFloat(element.dataset.target || element.textContent.replace(/[^\d.]/g, ''));
            if (target === 0) return;

            const duration = 2000;
            const increment = target / (duration / 16);
            let current = 0;

            const timer = setInterval(() => {
                current += increment;
                if (current >= target) {
                    current = target;
                    clearInterval(timer);
                }

                // Format number based on whether it's decimal or integer
                if (target % 1 === 0) {
                    element.textContent = Math.floor(current).toLocaleString('fa-IR');
                } else {
                    element.textContent = current.toFixed(1).toLocaleString('fa-IR');
                }
            }, 16);
        }

        // Show Loading
        showLoading() {
            const spinner = document.getElementById('loadingSpinner');
            if (spinner) {
                spinner.style.display = 'block';
            }
        }

        // Hide Loading
        hideLoading() {
            const spinner = document.getElementById('loadingSpinner');
            if (spinner) {
                spinner.style.display = 'none';
            }
        }

        // Show Notification
        showNotification(message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `notification notification-${type}`;
            notification.innerHTML = `
                <div class="notification-content">
                    <i class="fas fa-${this.getNotificationIcon(type)}"></i>
                    <span>${message}</span>
                </div>
                <button class="notification-close" onclick="this.parentElement.remove()">
                    <i class="fas fa-times"></i>
                </button>
            `;

            document.body.appendChild(notification);

            setTimeout(() => {
                if (notification.parentElement) {
                    notification.remove();
                }
            }, 5000);
        }

        getNotificationIcon(type) {
            switch (type) {
                case 'success': return 'check-circle';
                case 'error': return 'exclamation-circle';
                case 'warning': return 'exclamation-triangle';
                default: return 'info-circle';
            }
        }
    }

    // Initialize Ratings Manager
    const ratingsManager = new ModernRatingsManager();

    // Global Functions
    window.clearFilters = function() {
        ratingsManager.clearFilters();
    };

    window.confirmDelete = function(event, ratingName) {
        event.preventDefault();

        if (confirm(`آیا از حذف نظر "${ratingName}" اطمینان دارید؟\n\nاین عمل قابل بازگشت نیست.`)) {
            event.target.submit();
        }

        return false;
    };
});
</script>

<!-- Notification Styles -->
<style>
.notification {
    position: fixed;
    top: 20px;
    right: 20px;
    background: white;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
    padding: 1rem 1.5rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    z-index: 10000;
    min-width: 300px;
    animation: slideInRight 0.3s ease;
}

.notification-success {
    border-left: 4px solid #10b981;
}

.notification-error {
    border-left: 4px solid #ef4444;
}

.notification-warning {
    border-left: 4px solid #f59e0b;
}

.notification-info {
    border-left: 4px solid #3b82f6;
}

.notification-content {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.notification-content i {
    font-size: 1.25rem;
}

.notification-success .notification-content i {
    color: #10b981;
}

.notification-error .notification-content i {
    color: #ef4444;
}

.notification-warning .notification-content i {
    color: #f59e0b;
}

.notification-info .notification-content i {
    color: #3b82f6;
}

.notification-close {
    background: none;
    border: none;
    color: #6b7280;
    cursor: pointer;
    padding: 0.25rem;
    border-radius: 4px;
    transition: all 0.2s ease;
}

.notification-close:hover {
    background: #f3f4f6;
    color: #374151;
}

@keyframes slideInRight {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/user/ratings/index.blade.php ENDPATH**/ ?>